{********************************************************************************************
 **                                 TestTrig.Pas Unit                                      **
 **  ------------------------------------------------------------------------------------  **
 **		This unit generates a sine and cosine lookup table.  This is an optimization         **
 **		technique which greatly speeds up Trig functions, since they use so much Sines,      **
 **   Cosines, etc.  Using this technique, a program generates all of the possible values  **
 **   before hand, and then looks them up in a table when they are needed.  This avoids    **
 **   using the very slow built in Trig functions.                                         **
 ********************************************************************************************}

unit Testtrig;

interface

type
    tsinearray = array[0..359] of real;
    tcosinearray = array[0..359] of real;

var
   sinearray: ^tsinearray;
   cosinearray: ^tcosinearray;

procedure initsinearray;
procedure initcosinearray;
procedure destroysinearray;
procedure destroycosinearray;

implementation

procedure initsinearray;
var
   count: integer;
begin
     getmem(sinearray, sizeof(tsinearray));
     for count:=0 to 359 do
         sinearray^[count]:=sin((count)*(pi / 180));
end;

procedure initcosinearray;
var
   count: integer;
begin
     getmem(cosinearray, sizeof(tcosinearray));
     for count:=0 to 359 do
         cosinearray^[count]:=cos((count)*(pi / 180));
end;

procedure destroysinearray;
begin
     freemem(sinearray, sizeof(tsinearray));
end;

procedure destroycosinearray;
begin
     freemem(cosinearray, sizeof(tcosinearray));
end;

end.
